********************************************************************************
************************************  ANALYSIS  ********************************
********************************************************************************

cd "$master\output"

** Table 1. Descriptives
use rctmanagement_master, clear
tabulate partner, gen(partner)
tabulate facility_type, gen(facility_type)
tabulate dar, gen(dar)
tabulate urban, gen(urban)
tabulate treat_binary, gen(treat_binary)
g sample=(mngmt_score_obs1!=.)

tabstat mngmt_score_obs1 management_score_mean, s(n  mean sd min max)
tabstat treat_binary2 treat_binary1 partner1 partner2 facility_type1 facility_type2 facility_type3 dar1 dar2 urban1 urban2 urban3 if sample==1, s(n  mean sd min max)

outreg2 using table1a.xls,  replace sum(log) eqkeep(mean sd min max N) keep(mngmt_score_obs1 management_score_mean)
outreg2 using table1c.xls if sample==1,  replace sum(log) eqkeep(mean sd min max N) keep(treat_binary2 treat_binary1 partner1 partner2 facility_type1 facility_type2 facility_type3 dar1 dar2 urban1 urban2 urban3)

use sp_master, clear
replace feestotalfee_corrected=feestotalfee_corrected/2264

tabstat correct_management_a effort_pc any_unnecessary_care total_abx feestotalfee_corrected, s(n  mean sd min max)
outreg2 using table1b.xls,  replace sum(log) eqkeep(mean sd min max N) keep(correct_management_a effort_pc any_unnecessary_care total_abx feestotalfee_corrected)

use ipc_master, clear
tabstat compliantindicationa, s(n  mean sd min max)
outreg2 using table1b.xls,  append sum(log) eqkeep(mean sd min max N) keep(compliantindicationa)

** Table 2. Management scores and correct treatment
* Note: SP case 1 is asthma, 2 is malaria, 3 is TB, 4 is URTI
use sp_master, clear
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary
global fixed i.spcase i.interviewercode 

* Panel A: Facility survey
reg correct_management_a mngmt_score_obs1  , cluster(code)
outreg2  using table2a.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates , cluster(code)
outreg2  using table2a.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table2a.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed  if treat_binary==0, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table2a.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
foreach depvar of varlist effort_pc irt_latent_reduced any_unnecessary_care total_abx {
	reg `depvar' mngmt_score_obs1 $covariates $fixed , cluster(code)
	local temp_r2=e(r2)*1.3
	psacalc beta mngmt_score_obs1, rmax(`temp_r2')
	local temp=r(beta)
	outreg2  using table2a.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
}

* Panel B: SafeCare assessment
reg correct_management_a management_score_mean  , cluster(code)
outreg2  using table2b.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
reg correct_management_a management_score_mean $covariates , cluster(code)
outreg2  using table2b.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
reg correct_management_a management_score_mean $covariates $fixed, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta management_score_mean, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table2b.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
reg correct_management_a management_score_mean $covariates $fixed  if treat_binary==0, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta management_score_mean, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table2b.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
foreach depvar of varlist effort_pc irt_latent_reduced any_unnecessary_care total_abx {
	reg `depvar' management_score_mean $covariates $fixed , cluster(code)
	local temp_r2=e(r2)*1.3
	psacalc beta management_score_mean, rmax(`temp_r2')
	local temp=r(beta)
	outreg2  using table2b.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
}

** Table 3. Management scores and compliance with infection prevention and control practices
* Note: Domain 1 is handwashing, 2 is PPE, 3 is injection and blood draw, 4 is disinfection, 5 is waste segregation
use ipc_master, clear
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary
global patient i.a2age1 i.a2gender1
global fixed i.indno

* Panel A: Facility survey
reg compliantindicationa mngmt_score_obs1 , cluster(code)
outreg2  using table3a.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg compliantindicationa mngmt_score_obs1 $covariates , cluster(code)
outreg2  using table3a.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg compliantindicationa mngmt_score_obs1 $covariates $patient , cluster(code)
outreg2  using table3a.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg compliantindicationa mngmt_score_obs1 $covariates $patient i.indno, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table3a.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg compliantindicationa mngmt_score_obs1 $covariates $patient i.indno if treat_binary==0, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table3a.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)

* Panel B: SafeCare assessment
reg compliantindicationa management_score_mean , cluster(code)
outreg2  using table3b.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
reg compliantindicationa management_score_mean $covariates , cluster(code)
outreg2  using table3b.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
reg compliantindicationa management_score_mean $covariates $patient , cluster(code)
outreg2  using table3b.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
reg compliantindicationa management_score_mean $covariates $patient i.indno, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta management_score_mean, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table3b.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)
reg compliantindicationa management_score_mean $covariates $patient i.indno if treat_binary==0, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta management_score_mean, rmax(`temp_r2')
local temp=r(beta)
outreg2  using table3b.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_score_mean)

** Table 4. Experimental effect of SafeCare intervention on management practices
use rctmanagement_master, clear
foreach var of varlist patient_score drug_score financial_score hr_score leader_score monitoring_score operations_score {
replace `var'=. if management_score_mean==.
}
global covariates numberofopdconsultingrooms numberofadmissionbeds 

reg mngmt_score_obs1 treat_binary i.strata1, robust
g sample=e(sample)
outreg2  using table4a.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)
mean mngmt_score_obs1 if sample==1 & treat_binary==0
drop sample
reg mngmt_score_obs1 treat_binary i.strata1 $covariates, robust
outreg2  using table4b.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)

reg management_score_mean treat_binary i.strata1, robust
g sample=e(sample)
outreg2  using table4a.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)
mean management_score_mean if sample==1 & treat_binary==0
drop sample
reg management_score_mean treat_binary i.strata1 $covariates baseline_management_score_mean, robust
outreg2  using table4b.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)

use sp_master, clear
egen strata1=group(zone hospital partner)
global covariates numberofopdconsultingrooms numberofadmissionbeds
global fixed i.spcase i.interviewercode

reg correct_management_a treat_binary i.strata1, cluster(code)
g sample=e(sample)
outreg2  using table4a.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)
mean correct_management_a if sample==1 & treat_binary==0
drop sample
reg correct_management_a treat_binary i.strata1 $covariates $fixed, cluster(code)
outreg2  using table4b.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)

use ipc_master, clear
egen strata1=group(zone hospital partner)
global covariates numberofopdconsultingrooms numberofadmissionbeds

reg compliantindicationa treat_binary i.strata1, cluster(code)
g sample=e(sample)
outreg2  using table4a.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)
mean compliantindicationa if sample==1 & treat_binary==0
drop sample
reg compliantindicationa treat_binary i.strata1 $covariates i.indno, cluster(code)
outreg2  using table4b.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)

** Figure 1. Histogram of management score 
use rctmanagement_master, clear
label var mngmt_score_obs1 "Observed management score"
hist mngmt_score_obs1, fraction bin(12) graphregion(color(white)) bgcolor(white)
graph export figure1.png, width(5000) height(3000)  replace

** Figure 2. Treatment effects on domains within the SafeCare management score
use rctmanagement_master, clear
foreach var of varlist patient_score drug_score financial_score hr_score leader_score monitoring_score operations_score {
replace `var'=. if management_score_mean==.
}
reg operations_score treat_binary i.strata1, robust
outreg2  using figure2.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)
foreach var of varlist patient_score drug_score financial_score hr_score  monitoring_score leader_score {
	reg `var' treat_binary i.strata1, robust
	outreg2  using figure2.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(treat_binary)
}

** Appendix Table B1
use rctmanagement_master, clear
tabulate incharge_type, gen(incharge_type)
tabulate dar, gen(dar)
tabulate urban, gen(urban)
g sample=(mngmt_score_obs1!=.)

tabstat incharge_type1 incharge_type2 incharge_type3 mo_per numberofopdconsultingrooms numberofadmissionbeds if sample==1, s(n  mean sd)
outreg2 using tableb1.xls if sample==1,  replace sum(log) eqkeep(mean sd min max N) keep(incharge_type1 incharge_type2 incharge_type3 mo_per numberofopdconsultingrooms numberofadmissionbeds)

** Appendix Table B2
* Note: SP case 1 is asthma, 2 is malaria, 3 is TB, 4 is URTI
use sp_master, clear
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary
global fixed i.interviewercode 
reg correct_management_a mngmt_score_obs1 $covariates $fixed  if spcase==1, robust
outreg2  using tableb2.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed  if spcase==2, robust
outreg2  using tableb2.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed  if spcase==3, robust
outreg2  using tableb2.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed  if spcase==4, robust
outreg2  using tableb2.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)

** Appendix Table B3
use sp_master, clear
replace feestotalfee_corrected=feestotalfee_corrected/2264
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary
global fixed i.spcase i.interviewercode 

reg feestotalfee_corrected mngmt_score_obs1 , cluster(code)
outreg2  using tableb3.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg feestotalfee_corrected mngmt_score_obs1 $covariates , cluster(code)
outreg2  using tableb3.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg feestotalfee_corrected mngmt_score_obs1 $covariates $fixed, cluster(code)
outreg2  using tableb3.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg feestotalfee_corrected mngmt_score_obs1 $covariates $fixed if treat_binary==0, cluster(code)
outreg2  using tableb3.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)

** Appendix Table B4
use sp_master, clear
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary mo_per
global fixed i.spcase i.interviewercode 

reg correct_management_a mngmt_score_obs1 $covariates $fixed, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using tableb4.xls, adds(Beta, `temp') replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg effort_pc mngmt_score_obs1 $covariates $fixed , cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using tableb4.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg irt_latent_reduced mngmt_score_obs1 $covariates $fixed , cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using tableb4.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg any_unnecessary_care mngmt_score_obs1 $covariates $fixed , cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using tableb4.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg total_abx mngmt_score_obs1 $covariates $fixed , cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using tableb4.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)

** Appendix Table B5
use ipc_master, clear
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary
global patient i.a2age1 i.a2gender1

reg compliantindicationa mngmt_score_obs1 $covariates $patient i.indno#i.staff_qual, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using tableb5.xls, adds(Beta, `temp') replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg compliantindicationa mngmt_score_obs1 $covariates $patient i.indno#i.staff_qual if treat_binary==0, cluster(code)
local temp_r2=e(r2)*1.3
psacalc beta mngmt_score_obs1, rmax(`temp_r2')
local temp=r(beta)
outreg2  using tableb5.xls, adds(Beta, `temp') append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)

** Appendix Table B6
use sp_master, clear
egen n=count(spcase), by(code)
replace opd_mean=opd_mean/n
egen management_both=rowmean(mngmt_score1_v2 mngmt_score_obs1)
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary
global fixed i.spcase i.interviewercode 
global more_covariates i.incharge_type  numberofopdconsultingrooms numberofadmissionbed

reg correct_management_a mngmt_score_obs1 $covariates $fixed, cluster(code)
outreg2  using tableb6.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed $more_covariates, cluster(code)
outreg2  using tableb6.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed if confirmed_possible_detection!=1, cluster(code)
outreg2  using tableb6.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs1 $covariates $fixed [aw=opd_mean], cluster(code)
outreg2  using tableb6.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
probit correct_management_a mngmt_score_obs1 $covariates $fixed, vce(cluster code)
margins, dydx(mngmt_score_obs1) post
outreg2  using tableb6.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg correct_management_a mngmt_score_obs_pcf $covariates $fixed, cluster(code)
outreg2  using tableb6.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs_pcf)
reg correct_management_a z_mngmt_score_obs $covariates $fixed, cluster(code)
outreg2  using tableb6.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(z_mngmt_score_obs)
reg correct_management_a management_both $covariates $fixed, cluster(code)
outreg2  using tableb6.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_both)

** Appendix Table B7
use ipc_master, clear
egen management_both=rowmean(mngmt_score1_v2 mngmt_score_obs1)
global covariates i.facility_type i.regioncode i.partner i.urban treat_binary
global patient i.a2age1 i.a2gender1
global fixed i.indno
global more_covariates i.incharge_type  numberofopdconsultingrooms numberofadmissionbed

reg compliantindicationa mngmt_score_obs1 $covariates $patient $fixed, cluster(code)
outreg2  using tableb7.xls, replace label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg compliantindicationa mngmt_score_obs1 $covariates $patient $fixed $more_covariates, cluster(code)
outreg2  using tableb7.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
probit compliantindicationa mngmt_score_obs1 $covariates $patient $fixed, vce(cluster code)
margins, dydx(mngmt_score_obs1) post
outreg2  using tableb7.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs1)
reg compliantindicationa mngmt_score_obs_pcf $covariates $patient $fixed, cluster(code)
outreg2  using tableb7.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(mngmt_score_obs_pcf)
reg compliantindicationa z_mngmt_score_obs $covariates $patient $fixed, cluster(code)
outreg2  using tableb7.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(z_mngmt_score_obs)
reg compliantindicationa management_both $covariates $patient $fixed, cluster(code)
outreg2  using tableb7.xls, append label bdec(3) dec(3) pdec(4) stats(coef se)  nocons keep(management_both)

** Appendix Table B8
use rctmanagement_master, clear
tabulate partner, gen(partner)
tabulate facility_type, gen(facility_type)
tabulate dar, gen(dar)
tabulate urban, gen(urban)

tabstat numberofopdconsultingrooms numberofadmissionbeds, by(treat_binary) s(n  mean sd)
tabstat partner1 partner2 facility_type1 facility_type2 facility_type3 dar1 dar2 urban1 urban2 urban3, by(treat_binary) s(n  mean sd)
outreg2 using tableb8.xls if treat_binary==1,  replace sum(log) eqkeep(mean sd) keep(numberofopdconsultingrooms numberofadmissionbeds partner1 partner2 facility_type1 facility_type2 facility_type3 dar1 dar2 urban1 urban2 urban3)
outreg2 using tableb8.xls if treat_binary==0,  append sum(log) eqkeep(mean sd) keep(numberofopdconsultingrooms numberofadmissionbeds partner1 partner2 facility_type1 facility_type2 facility_type3 dar1 dar2 urban1 urban2 urban3)

